/*
 * Decompiled with CFR 0.152.
 */
package com.android.order.domain.use_case.read;

import com.android.order.domain.model.AOrderDtlDto;
import com.android.order.domain.use_case.read.FetchAOrderDetails;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
class FetchAOrderDetails {
    private final DbConnection dbConnection;

    public List<AOrderDtlDto> invoke(LoginDto login, @Nullable List<String> orderIdList) {
        String commaBoundResult = ConvertStr.commaBindStringsWithQuotes(orderIdList);
        String whereStr = (String)ConvertStr.ifElse((boolean)ConvertStr.isNullOrEmpty((String)commaBoundResult), () -> "", () -> " AND rqd.RqIndex in (" + commaBoundResult + ") \n");
        String sql = "SELECT rqd.R_ArCode AS productCode, (S.M_groupcode + S.S_groupcode) AS productGroupCode, \n rqd.RqIndex AS orderId, IsNull(rqd.R_Few, 0) AS amount, IsNull(rqd.R_Cost, 0) AS price, \n rqd.RqIncIndex AS serverId, rqd.R_commen AS description, IsNull(rqd.R_Few2, 0) AS secondAmount, \n IsNull(rqd.R_Few3, 0) AS thirdAmount, IsNull(rqd.Unit_Code, -1) AS unitCode, \n IsNull(u.Unit_Few, 1) AS coefficient, rqd.DarsadTakhfif discountPercent, \n TakhfifSatriR discountPrice, IsNull(ShowOrHide, 1) notConvertedToInvoice, \n IsNull(k_Fac_Code, '') orderCode, IsNull(A_IndexK_FacCode, 0) metricRowIndex, \n IsNull(k_FacType, '') orderType, IsNull([Tool], '') length, IsNull(Arz, '') width, \n IsNull(ToolArzType, '') lengthWidthType, IsNull(DeliveryTimeId, 0) metricDeliveryDateId, \n rqd.selPriceId sellPriceId \n FROM RqDetail rqd \n INNER JOIN RQTITLE rq ON rq.RqIndex = rqd.RqIndex \n INNER JOIN M_Group M ON SubString(rqd.R_ArCode, 1, 2) = M.M_GroupCode \n INNER JOIN S_Group S ON M.M_GroupCode = S.M_GroupCode \n   AND SubString(rqd.R_ArCode, 3, 2) = S.S_GroupCode \n LEFT JOIN Unit u ON u.Unit_Code = rqd.Unit_Code \n WHERE ((isNull(rqd.Show_Or_Hide, 0) = 1 AND rqd.R_FewAval = rqd.R_Few)   OR isNull(rqd.Show_Or_Hide, 0) = 0) " + whereStr + " ORDER BY rqd.RqIndex, rqd.RqIncIndex";
        return this.dbConnection.getJdbcTemplate(login).query(sql, (RowMapper)new DtlMapper(null));
    }

    public FetchAOrderDetails(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
    }
}

